/*
Wakanda Software (the "Software") and the corresponding source code remain
the exclusive property of 4D and/or its licensors and are protected by national
and/or international legislations.
This file is part of the source code of the Software provided under the relevant
Wakanda License Agreement available on http://www.wakanda.org/license whose compliance
constitutes a prerequisite to any use of this file and more generally of the
Software and the corresponding source code.
*/


RestDirectoryAccess = {};

RestDirectoryAccess.loginByKey = function(userName, key, timeout)
{
	return ds.loginByKey(userName, key, timeout);
}

RestDirectoryAccess.login = function(userName, password, timeout)
{
	return ds.loginByPassword(userName, password, timeout);
}

RestDirectoryAccess.loginByPassword = RestDirectoryAccess.login;

RestDirectoryAccess.logout = function()
{
	ds.logout();
	return true;
}

RestDirectoryAccess.currentUser = function()
{
	var user = ds.currentUser();
	if (user == null)
		return null;
	else
		return {
			userName: user.name,
			fullName: user.fullName,
			ID: user.ID
		}
}

RestDirectoryAccess.currentUserBelongsTo = function(group) {
    var session = ds.currentSession();
    if (session == null)
        return false;
    else
        return session.belongsTo(group);
}

